#ifndef __PROFIBUS_FSPMM_DIAG_H
#define __PROFIBUS_FSPMM_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS Master APM Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_NO_INIT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Data Link failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_NO_INIT_PACKET ((TLR_RESULT)0xC0380001L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_BUS_PARAMETER_REJECTED
//
// MessageText:
//
//  Command for setting the bus parameter is rejected.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_BUS_PARAMETER_REJECTED ((TLR_RESULT)0xC0380002L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_SSAP_ACTIVATE_FAIL
//
// MessageText:
//
//  Activating the source SAP failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_SSAP_ACTIVATE_FAIL ((TLR_RESULT)0xC0380003L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_STATE_ERROR
//
// MessageText:
//
//  DMPMM state maschine is at an invalid state.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_STATE_ERROR ((TLR_RESULT)0xC0380004L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_FSPMM_STATE_ERROR
//
// MessageText:
//
//  FSPMM state maschine is at an invalid state.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_FSPMM_STATE_ERROR ((TLR_RESULT)0xC0380005L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_MSCY1M_STATE_ERROR
//
// MessageText:
//
//  MSCY1M state maschine is at an invalid state.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_MSCY1M_STATE_ERROR ((TLR_RESULT)0xC0380006L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_SSAP_ACTIVATE_RESPONDER_FAIL
//
// MessageText:
//
//  Activate RSAP failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_SSAP_ACTIVATE_RESPONDER_FAIL ((TLR_RESULT)0xC0380007L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_NO_GLBCNTRL_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send global control failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_DMPMM_NO_GLBCNTRL_PACKET ((TLR_RESULT)0xC0380008L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_NOT_SUPPORTED
//
// MessageText:
//
//  Function is not supported at the actual version of the stack.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_NOT_SUPPORTED ((TLR_RESULT)0xC0380009L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_NO_DATABASE
//
// MessageText:
//
//  No database found.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_NO_DATABASE ((TLR_RESULT)0xC038000AL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_INVALID_DATABASE
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Master state machine failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_INVALID_DATABASE ((TLR_RESULT)0xC038000BL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_UNKNOWN_TELEGRAM
//
// MessageText:
//
//  Telegram with an unknown SAP was received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_UNKNOWN_TELEGRAM ((TLR_RESULT)0xC038000CL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_UNKNOWN_DPV1_CMD
//
// MessageText:
//
//  Answer of an invalid DP V1 service received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_UNKNOWN_DPV1_CMD ((TLR_RESULT)0xC038000EL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMM_TASK_PRM_VERSION_INVALID
//
// MessageText:
//
//  Ungltige Version der Task Parameter.
//
#define TLR_DIAG_E_PROFIBUS_FSPMM_TASK_PRM_VERSION_INVALID ((TLR_RESULT)0xC0380010L)




#endif  //__PROFIBUS_FSPMM_DIAG_H

